@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <div class="card card-primary card-outline">
                        <div class="card-header">
                            <h3 class="card-title">{{__('Virtual System')}}</h3>
                        </div>
                        <div class="card-body">

                            <table class="table table-striped table-bordered text-center datatable" data-system="systems">
                                <thead>
                                <tr>
                                    <th>{{__('Ticket title')}}</th>
                                    <th>{{__('Message')}}</th>
                                    <th>{{__('User Note')}}</th>
                                    <th>{{__('Reply By')}}</th>
                                </tr>
                                </thead>
                                <tbody>
                                    @forelse($messages ?? [] as $message)
										@if($message->ticket)
	                                        <tr>
	                                            <td><a href="{{route('dashboard.support.tickets.view',[$message->ticket->id])}}">{{$message->ticket->title}}</a> </td>
	                                            <td>{!!$message->message!!}</td>
	                                            <td>{{$message->note}}</td>
	                                            <td><a href="{{route('dashboard.virtual.edit',['users',$message->user->id])}}">{{$message->user->name}}</a></td>
	                                        </tr>
										@endif
                                    @empty
                                        <tr><td colspan="3">{{__('No Data')}}</td></tr>
                                    @endforelse
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td>{{__('Search By')}} {{__('ID')}}</td>
                                    <td class="text-left">{{__('Search By')}} {{__('Message')}}</td>
                                    <td class="text-left">{{__('Search By')}} {{__('Note')}}</td>
                                    <td class="text-left">{{__('Search By')}} {{__('Name')}}</td>
                                </tr>
                                </tfoot>
                            </table>

                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">

                        </div>
                        <!-- /.card-footer-->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
@endsection
