@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <div class="card card-primary card-outline">
                        <div class="card-header">
                            <h3 class="card-title">{{__('Survey reports')}}</h3>
                        </div>
                        <div class="card-body">
							<h3>{{$Survey->title}}</h3>
							<hr>
							<div class="">
								<a href="{{route('dashboard.surveys.reports',['id'=>$Survey->id])}}" class="btn btn-success @if(request('role_id')=='') btn-info @endif ">
									{{__('All')}}
								</a>
								@foreach ($Survey->roles as $role)
									<a href="{{route('dashboard.surveys.reports',['id'=>$Survey->id,'role_id'=>$role->id])}}" class="btn btn-success @if(request('role_id')==$role->id) btn-info @endif ">
										{{$role['name_'.\Config::get('app.locale')]}}
									</a>
								@endforeach
							</div>
							<hr>

                            <table class="table table-striped table-bordered text-center datatable" data-system="surveys_submission">
                                <thead>
	                                <tr>
	                                    <th>{{__('ID')}}</th>
										@if ($Survey->type=='evaluation')
											@foreach ($Survey->domains as $domain)

												@php
													$Users = [];
													$result = \DB::table('under_evaluation_surveys_domains_users_roles_r')->where('survey_domain_id',$domain->id)->get();
													foreach ($result as $li) {
														$role = \App\UserRole::where('id',$li->user_role_id)->with('users')->first();
														foreach ($role->users as $user) {
															$Users[$user['id']] = $user;
														}
													}
												@endphp

												@foreach ($Users as $user)
													@foreach ($domain->rating as $rate)
					                                    <th>{{$domain->code}}-{{$user->id}}-{{$rate->code}}</th>
													@endforeach
												@endforeach
											@endforeach
										@else
											@foreach ($Survey->domains as $domain)
												@foreach ($domain->elements as $element)
													@foreach ($domain->rating as $rate)
					                                    <th>{{$domain->code}}-{{$element->code}}-{{$rate->code}}</th>
													@endforeach
												@endforeach
											@endforeach
										@endif
	                                    <th class="project-actions">{{__('Actions')}}</th>
	                                </tr>
                                </thead>
                                <tbody>
									@php
										$bypass = true;
										$users = [];
										if(!empty(\request('role_id'))){
											$Role = \App\UserRole::find(\request('role_id'));
											foreach ($Role->users as $user) {
												$users[] = $user['id'];
											}
											$bypass = false;
										}else{
											foreach ($Survey->roles as $role){
												$Role = \App\UserRole::find($role->id);
												foreach ($Role->users as $user) {
													$users[] = $user['id'];
												}
											}
										}
										$submission_by = [];
									@endphp

									@foreach ($submissions as $row)
										@if($bypass || in_array($row->user_id,$users))
											@php
												$submission_by[] = $row->user_id;
												$row->submission = json_decode($row->submission,true);
											@endphp
											<tr>
												<td>{{$row->id}}</td>
												@if ($Survey->type=='evaluation')
													@foreach ($Survey->domains as $domain)
														@foreach ($Users as $user)
															@foreach ($domain->rating as $rate)
																<td>{{$row->submission['rate-'.$user->id.'-'.$rate->id]}}</td>
															@endforeach
														@endforeach
													@endforeach
												@else
													@foreach ($Survey->domains as $domain)
														@foreach ($domain->elements as $element)
															@foreach ($domain->rating as $rate)
																<td>{{$row->submission['rate-'.$element->id.'-'.$rate->id]}}</td>
															@endforeach
														@endforeach
													@endforeach
												@endif
												<th class="project-actions">
													<button class="btn btn-danger btn-sm delete_record" type="button" data-id="{{$row->id}}" data-toggle="modal" data-target="#delete_modal">
														<i class="fas fa-trash"></i>
													</button>
												</th>
											</tr>
										@endif
									@endforeach
                                </tbody>
                                <tfoot>
	                                <tr>
	                                    <td>{{__('Search By')}} {{__('ID')}}</td>
										@if ($Survey->type=='evaluation')
											@foreach ($Survey->domains as $domain)
												@foreach ($Users as $user)
													@foreach ($domain->rating as $rate)
														<td>درجه التقييم</td>
													@endforeach
												@endforeach
											@endforeach
										@else
											@foreach ($Survey->domains as $domain)
												@foreach ($domain->elements as $element)
													@foreach ($domain->rating as $rate)
														<td>درجه التقييم</td>
													@endforeach
												@endforeach
											@endforeach
										@endif
										<td class="project-actions">-</td>
	                                </tr>
                                </tfoot>
                            </table>

							<br>
							<br>
							<hr>
							<br>
							<br>

							<table class="table table-striped table-bordered text-center datatable">
                                <thead>
	                                <tr>
	                                    <th>{{__('ID')}}</th>
	                                    <th>{{__('Username')}}</th>
	                                    <th>{{__('Submission')}}</th>
	                                </tr>
                                </thead>
                                <tbody>
									@php
										$users = \App\User::whereIn('id',$users)->get();
									@endphp
									@foreach ($users as $user)
										<tr>
											<td>{{$user->id}}</td>
											<td>{{$user->name}}</td>
											<td>
												@if(in_array($user->id,$submission_by))
													{{__('Yes')}}
												@else
													{{__('No')}}
												@endif
											</td>
										</tr>
									@endforeach
                                </tbody>
                                <tfoot>
	                                <tr>
	                                    <td>{{__('Search By')}} {{__('ID')}}</td>
	                                    <td>{{__('Search By')}} {{__('Username')}}</td>
	                                    <td>{{__('Search By')}} {{__('Submission')}}</td>
	                                </tr>
                                </tfoot>
                            </table>

                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
							<a href="{{route('dashboard.virtual-system.index', ['page_slug' => 'surveys' ] )}}" class="btn btn-sm btn-secondary"><i class="fa fa-arrow-left"></i> {{__('Back')}}</a>
                        </div>
                        <!-- /.card-footer-->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>


    <!-- Delete Modal -->
    <div class="modal fade" id="delete_modal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">{{__('Delete Record')}} "<span id="record_id"></span>"</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    {{__('Do You want to delete this record')}}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('Close')}}</button>
                    <button type="button" class="btn btn-danger" id="delete_record" data-id="" data-dismiss="modal" data-url="{{route('dashboard.surveys.submission.delete', [ ] )}}">{{__('delete')}}</button>
                </div>
            </div>
        </div>
    </div>
@endsection
