@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->

                    <form class="card card-primary card-outline validate-form" data-system="{{$system->slug}}" @if(isset($record[$system->key])) data-type="edit" @else  data-type="new" @endif @isset($record[$system->key]) data-id="{{$record[$system->key]}}" @endisset id="form" action="@if(isset($record[$system->key])) {{ route('dashboard.virtual-system.edit', [ 'record_id' => $record[$system->key], 'page_slug' => $system->slug ]) }} @else {{route('dashboard.virtual-system.create', ['page_slug' => $system->slug ])}} @endif">
                        <div class="card-header">
                            <h3 class="card-title">@if(isset($record[$system->key])) {{__('Edit')}} @else {{__('New')}} @endif {{$title}}</h3>
                        </div>

                        <div class="card-body">
                            @foreach($system->fields as $Field)
                                @if($Field['type']!="key")
                                    @if($Field['type']=="content")
                                        @if($Field['multi_languages']=="1")

                                            <nav class="languagesNav">
                                                <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
                                                    @foreach(\Config::get('app.languages') as $language)
                                                        <a class="nav-item nav-link @if($language->prefix==\Config::get('app.locale'))  active @endif" id="{{$Field['name'].'_'.$language->prefix}}-tab" data-toggle="tab" href="#{{ $Field['name'].'_'.$language->prefix }}" role="tab" aria-controls="{{ $Field['name'].'_'.$language->prefix }}" aria-selected="true">{{ $language->name }}</a>
                                                    @endforeach
                                                </div>
                                            </nav>
                                            <div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
                                                @foreach(\Config::get('app.languages') as $language)
                                                    <div class="tab-pane fade @if($language->prefix==\Config::get('app.locale')) show active @endif " id="{{ $Field['name'].'_'.$language->prefix }}" role="tabpanel" aria-labelledby="{{ $Field['name'].'_'.$language->prefix }}-tab">
                                                        <div class="form-group row">
                                                            <div class="col-sm-12">
                                                                <label for="{{ $Field['name'].'_'.$language->prefix }}" class="col-form-label">{{ $Field['label'][\Config::get('app.locale')] }} [{{ $language->prefix }}]</label>
                                                                <textarea style="direction:{{$language->dir}} !important;" dir="{{$language->dir}}" rows="3" class="form-control summernote" id="{{ $Field['name'].'_'.$language->prefix }}" name="{{ $Field['name'].'_'.$language->prefix }}" placeholder="{{ $Field['label'][\Config::get('app.locale')] }} [{{ $language->prefix }}]">@isset($record[$Field['name'].'_'.$language->prefix]) {!! base64_decode($record[$Field['name'].'_'.$language->prefix]) !!} @endisset </textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @else
                                            <div class="form-group row">
                                                <div class="col-sm-12">
                                                    <label for="{{ $Field['name'] }}" class="col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
                                                    <textarea rows="3" class="form-control summernote" id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" placeholder="{{ $Field['label'][\Config::get('app.locale')] }} ">{!! base64_decode($record[$Field['name']] ?? '') !!}</textarea>
                                                </div>
                                            </div>
                                        @endif

                                    @elseif($Field['type']=="icon")
                                        <div class="form-group row">
                                            <label for="{{$Field['name']}}" class="col-sm-2 col-form-label">{{$Field['label'][\Config::get('app.locale')]}}</label>
                                            <div class="col-sm-10">
                                                <select class="form-control select2 font-awesome-select2" id="{{$Field['name']}}" name="{{$Field['name']}}">
                                                    @foreach(json_decode(file_get_contents(base_path('resources/font-awesome-v5.json'))) as $icon)
                                                        <option value="{{$icon}}" data-icon="{{$icon}}" @if($Record[$Field['name']]=="fa-500px") selected @endif >{{$icon}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
									@elseif($Field['type']=="avatar")
										<div class="form-group row">
                                            <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
                                            <div class="col-sm-10">
                                                <input type="text" data-type='avatar' value="{{ $record[$Field['name']] ?? '' }}" class="form-control" id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" disabled />
                                                <i class="far fa-folder-open file_manger_icon"></i>
                                            </div>
                                        </div>
									@elseif($Field['type']=="multimedia")
										<div class="form-group row">
											<label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
											<div class="col-sm-10">
												<input type="text" hidden data-type='multimedia' value="{{ $record[$Field['name']] ?? '' }}" class="form-control" id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" disabled />
												<i class="far fa-folder-open file_manger_icon"></i>
												<div class="multimedia" data-name="{{ $Field['name'] }}">
													<div class="row">
														@foreach ( DB::select(" select * from `".$Field['name'].'_'.$system->table."_media` inner join `media` on `media`.`id` = `".$Field['name'].'_'.$system->table."_media`.`media_id`  where `".Str::singular($system->table)."_id` = ? ",[$record[$system->key] ?? '']) as $row)
															<div class="col-md-3" data-id="{{ $row->media_id}}">
																<span class="fa fa-trash deleteImage"></span>
																@if ($row->extension=="mp4")
																	<video width='320' height='240' controls> <source src='{{asset('/storage/images/original/'.$row->name)}}' type='video/mp4'> Your browser does not support the video tag. </video>
																@else
																	<img src="{{url("/storage/images/original/".$row->name)}}">
																@endif
															</div>
														@endforeach
													</div>
												</div>
											</div>
										</div>
									@elseif($Field['type']=="image")
										<div class="form-group row">
											<label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
											<div class="col-sm-10">
												<input type="text" data-type='image' value="{{ $record[$Field['name']] ?? '' }}" class="form-control" id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" disabled />
												<i class="far fa-folder-open file_manger_icon"></i>
											</div>
										</div>
                                    @elseif($Field['type']=="pdf")
										<div class="form-group row">
                                            <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
                                            <div class="col-sm-10">
                                                <input type="text" data-type='pdf' value="{{ $record[$Field['name']] ?? '' }}" class="form-control" id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" disabled />
                                                <i class="far fa-folder-open file_manger_icon"></i>
                                            </div>
                                        </div>
                                    @elseif($Field['type']=="file")
                                        <div class="form-group row">
                                            <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
                                            <div class="col-sm-10">
                                                <input type="text" data-type='file' value="{{ $record[$Field['name']] ?? '' }}" class="form-control" id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" disabled />
                                                <i class="far fa-folder-open file_manger_icon"></i>
                                            </div>
                                        </div>
                                    @elseif($Field['type']=="check_box")
                                        <div class="form-group row">
                                            <div class="col-sm-12">
                                                <div class="icheck-primary">
                                                    <input type="checkbox" class="form-control" id="{{ $Field['name'] }}" name="{{ $Field['name'].'_'.$language->prefix }}" @if($record[$Field['name']]=="1") checked @endif />
                                                    <label for="{{ $Field['name'] }}">{{ $Field['label'][\Config::get('app.locale')] }}</label>
                                                </div>
                                            </div>
                                        </div>
                                    @else
                                        @if($Field['has_relation']=="1")
                                            @if($Field['relation']['type']=='many')

												@php
													$key = explode('_',$Field['relation']['table']);
													foreach ($key as $i => $word) {
														$key[$i] = Str::singular($word);
													}
													$key = implode('_',$key).'_id';

													$key2 = explode('_',$system->table);
													foreach ($key2 as $i => $word) {
														$key2[$i] = Str::singular($word);
													}
													$key2 = implode('_',$key2).'_id';

													$data = DB::select(" select * from `".$Field['relation']['table']."` ");
													$data = collect($data)->map(function($x){ return (array) $x; })->toArray();

													if(empty($record[$system->key])){
														$record[$Field['name']] = NULL;
													}else{
														$record[$Field['name']] = DB::table($Field['name'].'_'.$system->table.'_'.$Field['relation']['table']."_r")->where($key2,$record[$system->key])->get();
														$record[$Field['name']] = collect($record[$Field['name']])->map(function($x){ return (array) $x; })->toArray();
														$keys_array = [];
														foreach($record[$Field['name']] as $row){
															$keys_array[] = $row[$key];
														}
														$record[$Field['name']] = $keys_array;
													}
												@endphp

												@if($Field['type']=='checkboxlist')
													<hr />
													<div class="row">
														<label for="{{ $Field['name'] }}" class="col-md-12 form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
														@foreach($data as $value)
															<div class="col-md-4">
							                                    <div class="form-group">
							                                        <div class="custom-control custom-switch custom-switch-off-danger custom-switch-on-success">
							                                            <input type="checkbox" class="custom-control-input form-control checkboxlist" data-list="{{ $Field['name'] }}" value="{{ $value[$Field['relation']['key']] }}" id="{{ $value[$Field['relation']['key']] }}" name="{{ $value[$Field['relation']['key']] }}" @if( (is_array($record[$Field['name']]) && in_array($value[$Field['relation']['key']],$record[$Field['name']])) || (!is_array($record[$Field['name']]) && $value[$Field['relation']['key']]==$record[$Field['name']]) ) checked @endif />
							                                            <label class="custom-control-label" for="{{ $value[$Field['relation']['key']] }}">
																			@if($Field['multi_languages']=="1")
																			{{ $value[substr($Field['relation']['show'],0,-3).'_'.\Config::get('app.locale')] }}
																			@else
																				{{ $value[$Field['relation']['show']] }}
																			@endif
																		</label>
							                                        </div>
							                                    </div>
							                                </div>
														@endforeach
													</div>
												@else
	                                                <div class="form-group row">
	                                                    <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
	                                                    <div class="col-sm-10">
	                                                        <select class="form-control select2" data-placeholder="Select {{ $Field['label'][\Config::get('app.locale')] }}" multiple="multiple" id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" placeholder="{{ $Field['label'][\Config::get('app.locale')] }}">
	                                                            @foreach($data as $value)
	                                                                    <option value="{{ $value[$Field['relation']['key']] }}" @if( (is_array($record[$Field['name']]) && in_array($value[$Field['relation']['key']],$record[$Field['name']])) || (!is_array($record[$Field['name']]) && $value[$Field['relation']['key']]==$record[$Field['name']]) ) selected @endif >
	                                                                        @if($Field['multi_languages']=="1")
	                                                                        {{ $value[substr($Field['relation']['show'],0,-3).'_'.\Config::get('app.locale')] }}
	                                                                        @else
	                                                                            {{ $value[$Field['relation']['show']] }}
	                                                                        @endif
	                                                                    </option>
	                                                            @endforeach
	                                                        </select>
	                                                    </div>
	                                                </div>
												@endif
                                            @else

												@if(isset($Field['has_based_on']) && $Field['has_based_on']==1)
													<div class="form-group row">
	                                                    <label for="based_on_{{ $Field['name'] }}" class="col-sm-2 col-form-label"> based_on </label>
	                                                    <div class="col-sm-10">

	                                                        <select class="form-control select2" id="based_on_{{ $Field['name'] }}" name="based_on_{{ $Field['name'] }}" data-placeholder="select {{ $Field['label'][\Config::get('app.locale')] }}">
																<option value=""></option>

																@php
																	if(isset($record)){
																		$data1 = DB::select("select * from `".$Field['relation']['table']."` where  `".$Field['relation']['key']."` = '".$record[$Field['name']]."'      ");
																		$data1 = isset($data1[0]) ? collect($data1[0])->map(function($x){ return (array) $x; })->toArray() : [];
																	}

	                                                                $data = DB::select("select * from `".$Field['based_on']['table']."`");
	                                                                $data = collect($data)->map(function($x){ return (array) $x; })->toArray();
	                                                            @endphp

	                                                            @foreach($data as $value)
	                                                                @if($Field['multi_languages']=="1")
	                                                                    <option value="{{ $value[$Field['based_on']['table_key']] }}" @if( isset($data1[$Field['based_on']['key']][0]) && $value[$Field['based_on']['table_key']]==$data1[$Field['based_on']['key']][0])  selected @endif >{{ $value[substr($Field['based_on']['show'],0,-3).'_'.\Config::get('app.locale')] }}</option>
	                                                                @else
	                                                                    <option value="{{ $value[$Field['based_on']['table_key']] }}" @if( isset($data1[$Field['based_on']['key']][0]) && $value[$Field['based_on']['table_key']]==$data1[$Field['based_on']['key']][0]) selected @endif>{{ $value[$Field['based_on']['show']] }}</option>
	                                                                @endif
	                                                            @endforeach
	                                                        </select>
	                                                    </div>
	                                                </div>
												@endif

												<div class="form-group row">
                                                    <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
                                                    <div class="col-sm-10">


                                                        <select class="form-control @if(isset($Field['has_based_on']) && !empty($Field['has_based_on'])) select2-based_on @else select2 @endif" data-by="{{$Field['relation']['show']}}" data-source="{{route('dashboard.virtual-system.based-on')}}" data-based_on="based_on_{{ $Field['name'] }}" data-based_on_table="{{$Field['relation']['table']}}"
														@isset($Field['has_based_on'])
                                                        	 data-where="{{$Field['based_on']['key']}}"
                                                        @endisset id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" data-placeholder="select {{ $Field['label'][\Config::get('app.locale')] }}">
															<option value="" selected disabled>select value</option>
															@if(isset($Field['has_based_on']) && $Field['has_based_on']==1)
																@if(isset($data1) && !empty($data1))
																	<option value="{{ $data1[$Field['based_on']['key']][0] }}"  selected  >{{ $data1[$Field['based_on']['show']][0] }}</option>
																@endif
															@else
	                                                            @php
	                                                                $data = DB::select("select * from `".$Field['relation']['table']."`");
	                                                                $data = collect($data)->map(function($x){ return (array) $x; })->toArray();
	                                                            @endphp

	                                                            @foreach($data as $value)
	                                                                @if($Field['multi_languages']=="1")
	                                                                    <option value="{{ $value[$Field['relation']['key']] }}" @if( isset($record[$Field['name']]) && $value[$Field['relation']['key']]==$record[$Field['name']])  selected @endif >{{ $value[substr($Field['relation']['show'],0,-3).'_'.\Config::get('app.locale')] }}</option>
	                                                                @else
	                                                                    <option value="{{ $value[$Field['relation']['key']] }}" @if( isset($record[$Field['name']]) && $value[$Field['relation']['key']]==$record[$Field['name']]) selected @endif>{{ $value[$Field['relation']['show']] }}</option>
	                                                                @endif
	                                                            @endforeach

															@endif
                                                        </select>
                                                    </div>
                                                </div>
                                            @endif
                                        @elseif($Field['type']=="text")
                                            @if($Field['multi_languages']=="1")
                                                <nav class="languagesNav">
                                                    <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
                                                        @foreach(\Config::get('app.languages') as $language)
                                                            <a class="nav-item nav-link @if($language->prefix==\Config::get('app.locale')) active @endif " id="{{ $Field['name'].'_'.$language->prefix }}-tab" data-toggle="tab" href="#{{ $Field['name'].'_'.$language->prefix }}" role="tab" aria-controls="{{ $Field['name'].'_'.$language->prefix }}" aria-selected="true">{{ $language->name }}</a>
                                                        @endforeach
                                                    </div>
                                                </nav>
                                                <div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
                                                    @foreach(\Config::get('app.languages') as $language)
                                                        <div class="tab-pane fade @if($language->prefix==\Config::get('app.locale'))  show active @endif >" id="{{ $Field['name'].'_'.$language->prefix }}" role="tabpanel" aria-labelledby="{{ $Field['name'].'_'.$language->prefix }}-tab">
                                                            <div class="form-group row">
                                                                <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }} [{{ $language->prefix }}]</label>
                                                                <div class="col-sm-10">
                                                                    <input style="direction:{{$language->dir}} !important;" dir="{{$language->dir}}" type="text" class="form-control" id="{{ $Field['name'].'_'.$language->prefix }}" name="{{ $Field['name'].'_'.$language->prefix }}" value="{{ $record[$Field['name'].'_'.$language->prefix] ?? "" }}" placeholder="{{ $Field['label'][\Config::get('app.locale')]." [".$language->prefix."]" }}" />
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            @else
                                                <div class="form-group row">
                                                    <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
                                                    <div class="col-sm-10">
                                                        <input type="text" class="form-control" id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" value="{{ $record[$Field['name']] ?? '' }}" placeholder="{{ $Field['label'][\Config::get('app.locale')] }}" />
                                                    </div>
                                                </div>
                                            @endif
                                        @elseif($Field['type']=="long_text")
                                            @if($Field['multi_languages']=="1")
                                                <nav class="languagesNav">
                                                    <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
                                                        @foreach(\Config::get('app.languages') as $language)
                                                            <a class="nav-item nav-link @if($language->prefix==\Config::get('app.locale')) active @endif " id="{{ $Field['name'].'_'.$language->prefix }}-tab" data-toggle="tab" href="#{{ $Field['name'].'_'.$language->prefix }}" role="tab" aria-controls="{{ $Field['name'].'_'.$language->prefix }}" aria-selected="true">{{ $language->name }}</a>
                                                        @endforeach
                                                    </div>
                                                </nav>
                                                <div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
                                                    @foreach(\Config::get('app.languages') as $language)
                                                        <div class="tab-pane fade @if($language->prefix==\Config::get('app.locale')) show active @endif " id="{{ $Field['name'].'_'.$language->prefix }}" role="tabpanel" aria-labelledby="{{ $Field['name'].'_'.$language->prefix }}-tab">
                                                            <div class="form-group row">
                                                                <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }} [{{ $language->prefix }}]</label>
                                                                <div class="col-sm-10">
                                                                    <textarea style="direction:{{$language->dir}} !important;" dir="{{$language->dir}}" rows="3" class="form-control" id="{{ $Field['name'].'_'.$language->prefix }}" name="{{ $Field['name'].'_'.$language->prefix }}" placeholder="{{ $Field['label'][\Config::get('app.locale')] }} [{{ $language->prefix }}]">{{ $record[$Field['name'].'_'.$language->prefix] ?? '' }}</textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            @else
                                                <div class="form-group row">
                                                    <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
                                                    <div class="col-sm-10">
                                                        <textarea rows="3" class="form-control" id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" placeholder="{{ $Field['label'][\Config::get('app.locale')] }}">{{ $record[$Field['name']] ?? '' }}</textarea>
                                                    </div>
                                                </div>
                                            @endif
                                        @elseif($Field['type']=="options")
                                            <div class="form-group row">
                                                <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
                                                <div class="col-sm-10">
                                                    <select class="form-control select2" id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" placeholder="{{ $Field['label'][\Config::get('app.locale')] }}">
                                                        @foreach($Field['values'] as $value)
                                                            <option value="{{ $value['name'] }}" @if(isset($record[$Field['name']]) && $value['name']==$record[$Field['name']])  selected @endif >{{ $value['label'][\Config::get('app.locale')] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        @elseif($Field['type']=="number")
                                            <div class="form-group row">
                                                <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" value="{{ $record[$Field['name']] ?? '' }}" placeholder="{{ $Field['label'][\Config::get('app.locale')] }}" />
                                                </div>
                                            </div>
                                        @elseif($Field['type']=="password")
											@if(!isset($record[$system->key]))
	                                            <div class="form-group row">
	                                                <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
	                                                <div class="col-sm-10">
	                                                    <input type="password" class="form-control" id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" value="{{ $record[$Field['name']] ?? '' }}" placeholder="{{ $Field['label'][\Config::get('app.locale')] }}" />
	                                                </div>
	                                            </div>
											@endif
                                        @elseif($Field['type']=="date")
                                            <div class="form-group row">
                                                <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
                                                <div class="col-sm-10">
                                                    <input type="date" class="form-control" id="{{ $Field['name'] }}" name="{{ $Field['name'] }}" value="{{ $record[$Field['name']] ?? '' }}" placeholder="{{ $Field['label'][\Config::get('app.locale')] }}" />
                                                </div>
                                            </div>
                                        @elseif($Field['type']=="email")
                                            <div class="form-group row">
                                                <label for="{{ $Field['name'] }}" class="col-sm-2 col-form-label">{{ $Field['label'][\Config::get('app.locale')] }}</label>
                                                <div class="col-sm-10">
                                                    <input type="email" class="form-control" id="{{$Field['name']}}" name="{{$Field['name']}}" value="{{ $record[$Field['name']] ?? '' }}" placeholder="{{ $Field['label'][\Config::get('app.locale')] }}" />
                                                </div>
                                            </div>
                                        @endif
                                    @endif
                                @endif
                            @endforeach
                        </div>

                        <!-- /.card-body -->
                        <div class="card-footer text-right">
                            <a href="{{route('dashboard.virtual-system.index', ['page_slug' => $system->slug ] )}}" class="btn btn-sm btn-secondary"><i class="fa fa-arrow-left"></i> {{__('Back')}}</a>
                            <button type="button" id="submit_form" class="btn btn-sm btn-success"><i class="fa fa-check"></i> {{__('Save')}}</button>
                        </div>
                        <!-- /.card-footer-->
                    </form>
                </div>
                <!-- /.card -->
            </div>
        </div>
    </section>
@endsection
