@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <div class="card card-primary card-outline">
                        <div class="card-header">
                            <h3 class="card-title">{{$title}}</h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped table-bordered text-center datatable datatable-ajax" data-system="{{$system->slug}}" data-url="{{route('dashboard.virtual-system.data',[ 'page_slug' => $system->slug])}}">
                                <thead>
                                <tr>
									<th class="text-as-lang">#</th>
                                    @foreach($system->fields as $field)
                                        @if($field['display']==1)
                                            <th class="text-as-lang">{{$field['label'][Config::get('app.locale')]}}</th>
                                        @endif
                                    @endforeach
                                    <th class="project-actions">{{__('Actions')}}</th>
                                </tr>
                                </thead>
                                <tbody>

                                </tbody>
                                <tfoot>
                                <tr>
									<td><input type="text" class="data_table_filter" placeholder="{{__('Search By')}} {{__('ID')}}"></td>
                                    @foreach($system->fields as $field)
                                        @if($field['display']==1)
                                            <td class="text-as-lang">
												<input type="text" class="data_table_filter" value="{{request($field['name'])}}" placeholder="{{__('Search By')}} {{$field['label'][Config::get('app.locale')]}}">
											</td>
                                        @endif
                                    @endforeach
                                    <td class="project-actions">
										@if(\Gate::check('new-'.$system->slug) || \Gate::check('root-access') )
                                        <a class="btn btn-success btn-sm" href="{{route('dashboard.virtual-system.create', [ 'page_slug' => $system->slug  ])}}">
                                            <i class="fas fa-plus"></i>
                                            {{__('Add New')}}
                                        </a>
										@endif
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">

                        </div>
                        <!-- /.card-footer-->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

    <!-- Delete Modal -->
    <div class="modal fade" id="delete_modal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">{{__('Delete Record')}} "<span id="record_id"></span>"</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    {{__('Do You want to delete this record')}}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('Close')}}</button>
                    <button type="button" class="btn btn-danger" id="delete_record" data-id="" data-dismiss="modal" data-url="{{route('dashboard.virtual-system.delete', [ 'page_slug' => $system->slug ] )}}">{{__('delete')}}</button>
                </div>
            </div>
        </div>
    </div>
@endsection
