@extends('themes.MyLittleHouseSchool.app')

@section('content')




<!-- ===== Start of Blog Listing Section ===== -->
<section class="blog-listing ptb80" id="version1">
    <div class="container">
		<br>
		<br>
		<br>
        <div class="row">

            <div class="col-md-8 col-xs-12 blog-posts-wrapper">

                @foreach($posts ?? [] as $post)
					@php
						$post->structure();
					@endphp
                    <article class="blog-post">

                        <!-- Blog post Thumbnail -->
                        <div class="blog-thumbnail">
                            <a href="{{$post->url}}" class="hover-link">
								<picture>
									<source media="(max-width: 330px)" srcset="{{$post->thumbnail(300)['src']}}">
									<source media="(max-width: 767px)" srcset="{{$post->thumbnail(600)['src']}}">
									<source media="(max-width: 991px)" srcset="{{$post->thumbnail(450)['src']}}">
									<img src="{{$post->thumbnail(450)['src']}}" title="{{$post->title}}" class="img-responsive" />
								</picture>
                            </a>
                        </div>

                        <!-- Blog post Description -->
                        <div class="blog-desc">
                            <h5><a href="{{$post->url}}">{{$post->title}}</a></h5>
                            <p>{{$post->description}} ... <a href="{{$post->url}}">{{__('read more')}}</a></p>

                        </div>
                    </article>
                @endforeach

                <!-- Start of Pagination -->
				<div class="col-md-12 text-center">
					{{ $posts->links() }}
                </div>
                <!-- End of Pagination -->

            </div>

            <!-- Start of Blog Posts -->
            <div class="col-md-4 col-xs-12 blog-sidebar">
                @include('themes.MyLittleHouseSchool.inc.aside')
            </div>
            <!-- End of Blog Posts -->



        </div>
    </div>
</section>
@endsection

@section('scripts')
	<script src="{{asset('plugins/sticky/jquery.sticky-kit.js')}}"></script>
@endsection
