@extends('themes.MyLittleHouseSchool.app')

@section('content')
	<!-- =============== Start of Page Header 1 Section =============== -->
	<section class="page-header">
	    <div class="container">

	        <!-- Start of Page Title -->
	        <div class="row">
	            <div class="col-md-12">
					<h2>{{$page->title}}</h2>
	            </div>
	        </div>
	        <!-- End of Page Title -->

	        <!-- Start of Breadcrumb -->
			<div class="row">
				<div class="col-md-12">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
							<li class="breadcrumb-item active" aria-current="page">{{$page->title}}</li>
						</ol>
					</nav>
				</div>
	        </div>
	        <!-- End of Breadcrumb -->

	    </div>
	</section>
	<!-- =============== End of Page Header 1 Section =============== -->





	<!-- ===== Start of Login - Register Section ===== -->
	<section class="ptb80" id="login">
	    <div class="container">
	        <div class="col-md-6 offset-md-3 col-md-offset-3 col-xs-12">

	            <!-- Start of Login Box -->
	            <div class="login-box">
	                <!-- Start of Login Form -->
					<form method="POST" action="{{ route('password.update' , []) }}">
                        @csrf

						<input type="hidden" name="token" value="{{ $token }}">


						<div class="form-group">
							<label>Enter Your Email</label>
							<input type="email" name="email" class="form-control @error('email') is-invalid @enderror" placeholder="Email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus />
							@error('email')
								<span class="invalid-feedback" role="alert">
									<strong>{{ $message }}</strong>
								</span>
							@enderror
						</div>


						<div class="form-group">
							<label>Enter Your New Password</label>
							<input type="password" name="password" class="form-control @error('password') is-invalid @enderror" placeholder="new password" />
						</div>


						<div class="form-group">
							<label>Confirm Password</label>
							<input type="password" name="password_confirmation" class="form-control" placeholder="confirm password" />
						</div>

						<div class="form-group text-right">
	                        <button type="submit" name="restore" class="btn btn-success btn-effect">Restore</button>
	                    </div>


	                </form>
	                <!-- End of Login Form -->
	            </div>
	            <!-- End of Login Box -->

	        </div>
	    </div>
	</section>
	<!-- ===== End of Login - Register Section ===== -->
@endsection
