/**********************

Custom.js
=============

Author:  Gino Aliaj
Template: Cariera - Job Board HTML Template
Version: 1.0

Author URI: gnodesign.com
***************************/


(function ($) {

    "use strict";

    $(document).ready(function () {

        $('.searchform').on('submit', function(e){
            var term = $('.searchform input').val();
            term = term.replace(" ","+");
            location.href = $('meta[name=home]').attr('content')+"/search/" + term;
            e.preventDefault();
        });


        var veno_box = $('.venobox');
        veno_box.venobox();

        /*----------------------------------------------------
          STICKY HEADER
        ----------------------------------------------------*/

        // Calculating Header Height
        var header = $('header.sticky'),
            headerHeight = header.outerHeight();

        // Applying Header Height to the next Section
        header.next().css({
            'margin-top': headerHeight
        });





        /*----------------------------------------------------
           MENU
         ----------------------------------------------------*/
        var dropdown = $('.dropdown'),
            dropdownSubmenu = $('.dropdown-submenu'),
            dropdown_link = $('.dropdown > a'),
            dropdownSubmenu_link = $('.dropdown-submenu > a');

        if ($(window).width() > 992) {

            // Dropdown Function for all devices > 992px
            $(dropdown).on('mouseenter mouseleave tap', function () {
                $(this).toggleClass("open");
            });

            // Dropdown Submenu Function for all devices > 992px
            $(dropdownSubmenu).on('mouseenter mouseleave tap', function () {
                $(this).toggleClass("open");
            });

        } else {

            // Dropdown Function for all devices < 992px
            $(dropdown_link).on('click', function (e) {
                $(this).parent().siblings().removeClass('open').find('.dropdown-submenu').removeClass('open');
                $(this).parent().toggleClass('open').find('.dropdown-submenu').removeClass('open');
            });

            // Dropdown Submenu Function for all devices < 992px
            $(dropdownSubmenu_link).on('click', function (e) {
                $(this).parent().siblings().removeClass('open');
                $(this).parent().toggleClass('open');
            });

        }

        // If not enough space in right, display the submenu in the left
        function fixPositionSubmenu() {
            var menu = $('#main-nav .navbar-nav .dropdown-menu > .dropdown-submenu > .dropdown-menu');

            menu.each(function (e) {

                var leftPos = $(this).parent().offset().left + $(this).parent().width();
                if (leftPos + $(this).width() > $("body").width()) {
                    $(this).addClass("left");
                } else {
                    $(this).removeClass("left");
                }
            });
        }

        // calling the function
        fixPositionSubmenu();





        /*----------------------------------------------------
           PUSH MENU FOR DEVICES
         ----------------------------------------------------*/

        $.fn.jPushMenu = function (customOptions) {
            var o = $.extend({}, $.fn.jPushMenu.defaultOptions, customOptions);

            /* add class to the body.*/

            $('body').addClass(o.bodyClass);
            $(this).addClass('jPushMenuBtn');
            $(this).on('click', function () {
                var target = '',
                    push_direction = '';


                if ($(this).is('.' + o.showLeftClass)) {
                    target = '.cbp-spmenu-left';
                    push_direction = 'toright';
                } else if ($(this).is('.' + o.showRightClass)) {
                    target = '.cbp-spmenu-right';
                    push_direction = 'toleft';
                } else if ($(this).is('.' + o.showTopClass)) {
                    target = '.cbp-spmenu-top';
                } else if ($(this).is('.' + o.showBottomClass)) {
                    target = '.cbp-spmenu-bottom';
                }


                $(this).toggleClass(o.activeClass);
                $(target).toggleClass(o.menuOpenClass);

                if ($(this).is('.' + o.pushBodyClass)) {
                    $('body').toggleClass('cbp-spmenu-push-' + push_direction);
                }

                /* disable all other button*/
                $('.jPushMenuBtn').not($(this)).toggleClass('disabled');

                return false;
            });
            var jPushMenu = {
                close: function (o) {
                    $('.jPushMenuBtn,body,.cbp-spmenu').removeClass('disabled active cbp-spmenu-open cbp-spmenu-push-toleft cbp-spmenu-push-toright');
                }
            }

            if (o.closeOnClickOutside) {
                $(document).on('click', function () {
                    jPushMenu.close();
                });

                $(document).on('click touchstart', function () {
                    jPushMenu.close();
                });

                $('.cbp-spmenu,.toggle-menu').on('click', function (e) {
                    e.stopPropagation();
                });

                $('.cbp-spmenu,.toggle-menu').on('click touchstart', function (e) {
                    e.stopPropagation();
                });
            }

            // On Click Link
            if (o.closeOnClickLink) {
                $('.cbp-spmenu a').on('click', function () {
                    jPushMenu.close();
                });
            }
        };

        /* in case you want to customize class name,
         *  do not directly edit here, use function parameter when call jPushMenu.
         */
        $.fn.jPushMenu.defaultOptions = {
            bodyClass: 'cbp-spmenu-push',
            activeClass: 'menu-active',
            showLeftClass: 'menu-left',
            showRightClass: 'menu-right',
            showTopClass: 'menu-top',
            showBottomClass: 'menu-bottom',
            menuOpenClass: 'cbp-spmenu-open',
            pushBodyClass: 'push-body',
            closeOnClickOutside: true,
            closeOnClickInside: true,
            closeOnClickLink: false
        };

        //initilizer
        var toggleMenu = $('.toggle-menu');

        $(toggleMenu).jPushMenu({
            closeOnClickLink: false
        });




        /*----------------------------------------------------
           BUTTON EFFECT
         ----------------------------------------------------*/
        var button = $('.btn-effect');

        $(button).on('click', function (e) {

            // Remove any old one
            $('.ripple').remove();

            // Setup
            var posX = $(this).offset().left,
                posY = $(this).offset().top,
                buttonWidth = $(this).width(),
                buttonHeight = $(this).height();

            // Add the element
            $(this).prepend("<span class='ripple'></span>");


            // Make it round!
            if (buttonWidth >= buttonHeight) {
                buttonHeight = buttonWidth;
            } else {
                buttonWidth = buttonHeight;
            }

            // Get the center of the element
            var x = e.pageX - posX - buttonWidth / 2;
            var y = e.pageY - posY - buttonHeight / 2;


            // Add the ripples CSS and start the animation
            $('.ripple').css({
                width: buttonWidth,
                height: buttonHeight,
                top: y + 'px',
                left: x + 'px'
            }).addClass("rippleEffect");
        });



        /*----------------------------------------------------
          INITIALIZE SWIPER
        ----------------------------------------------------*/
        var swiper = new Swiper('.swiper-container', {
            prevButton: '.swiper-button-prev',
            nextButton: '.swiper-button-next',
            autoplay: 5000,
            loop: true
        });





        /*----------------------------------------------------
          MATCHING HEIGHT
        ----------------------------------------------------*/
        // Calculating Signup Sections Height
        var signupHeight = $('section#signup-video .signup-sec').outerHeight();

        // Applying Signup Sections Height into the Video Section
        $('section#signup-video .video-sec').css({
            "height": signupHeight
        });









        /*----------------------------------------------------
          INITIALIZE OWL SLIDER
        ----------------------------------------------------*/
        var testimonial = $('.testimonial'),
            partnerSlider = $('.partners-slider'),
            post_thumbnail_slider = $('.post-thumbnail-slider'),
            productSlider = $('.product-slider'),
            relatedJobs = $('.related-jobs'),
            portfoliogrid = $('.portfolio-grid.owl-carousel');

        // Initializing Owl Slider for Testimonial Section on the Home Version 1
        $(testimonial).owlCarousel({
            center: true,
            loop: true,
            nav: false,
            dots: false,
            autoplay: true, // set to "false" if you want to deactivate autoplay
            autoplaySpeed: 800,
			lazyLoad: true,

            //Responsive
            responsive: {
                0: { // breakpoint from 0 up - small smartphones
                    items: 1
                },
                992: { // breakpoint from 992 up - desktop
                    items: 3
                }
            }
        })

        // Initializing Owl Slider for Testimonial Section on the Home Version 1
        $(portfoliogrid).owlCarousel({
            center: true,
            loop: true,
            nav: false,
            dots: false,
            autoplay: true, // set to "false" if you want to deactivate autoplay
            autoplaySpeed: 800,
            margin: 20,
			lazyLoad: true,

            //Responsive
            responsive: {
                0: { // breakpoint from 0 up - small smartphones
                    items: 1
                },
                992: { // breakpoint from 992 up - desktop
                    items: 3
                }
            }
        })


        // Initializing Owl Slider for Partners Section
        $(partnerSlider).owlCarousel({
            loop: true,
            nav: false,
            dots: false,
            autoplay: true, // set to "false" if you want to deactive autoplay
			lazyLoad: true,

            //Responsive
            responsive: {
                0: {
                    items: 2
                },
                479: {
                    items: 2
                },
                768: {
                    items: 3
                },
                992: {
                    items: 4
                },
                1199: {
                    items: 6
                }
            }
        })


        // Initializing Owl Slider for Blog Post - Thumbnail
        $(post_thumbnail_slider).owlCarousel({
            items: 1,
            loop: true,
            autoplay: false,
			lazyLoad: true,

            //Navigation
            nav: true,
            dots: false,
            navSpeed: 800,
            navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],

        })


        // Initializing Owl Slider for Partners Section
        $(productSlider).owlCarousel({
            loop: true,
            nav: false,
            dots: true,
            autoplay: false, // set to "false" if you want to deactive autoplay
			lazyLoad: true,

            //Responsive
            responsive: {
                0: {
                    items: 1
                }
            }
        })

        // Initializing Owl Slider for Partners Section
        $(relatedJobs).owlCarousel({
            loop: true,
            nav: false,
            dots: true,
            autoplay: false, // set to "false" if you want to deactive autoplay
            margin: 20,
			lazyLoad: true,

            //Responsive
            responsive: {
                0: {
                    items: 1
                },
                479: {
                    items: 2
                },
                768: {
                    items: 3
                },
                992: {
                    items: 4
                }
            }
        })





        /*----------------------------------------------------
          BACK TO TOP FUNCTION
        ----------------------------------------------------*/

        // window scroll after the "back to top" button is shown
        var offset = 400;

        // duration of the top scrolling animation (in ms)
        var scroll_top_duration = 600;

        // grab the "back to top" link
        var back_to_top = $('.back-top');


        //hide - show the "back to top" button
        $(window).scroll(function () {
            ($(this).scrollTop() > offset) ? back_to_top.addClass('back-top-visible'): back_to_top.removeClass('back-top-visible');
        });

        //smooth scroll to top
        back_to_top.on('click', function (event) {
            event.preventDefault();
            $('body,html').animate({
                scrollTop: 0,
            }, scroll_top_duration);
        });


		/*----------------------------------------------------
          CONTACT FORM
        ----------------------------------------------------*/
		$("#SubmitContactForm").on('click', function(e) {

			toastr.clear();
			$('.error.invalid-feedback').remove();

		    var _this = $(this);
		    _this.children('i').addClass('fa-spin');
		    _this.children('i').addClass('fa-circle-o-notch');
		    _this.children('i').removeClass('fa-paper-plane-o');
		    _this.prop('disabled', true);

		    var dataString = {
		        name       : $('#ContactName').val(),
		        email      : $('#ContactEmail').val(),
		        phone      : $('#ContactPhone').val(),
		        subject    : $('#ContactSubject').val(),
		        message    : $('#ContactMessage').val(),
		    };

		    $.ajax({
		        type: "POST",
		        url: $('#contact-form').attr('action'),
		        data: dataString,
		        dataType    : 'json',
		        encode      : true,
		        success:function(data) {
		            if(data.success){
		                toastr.success(data.message);
		            }else{
		                if(data.message){
		                    toastr.error(data.message);
		                }
		                $.each(data.errors, function( index, value ) {
		                    toastr.error(value);
		                });
		            }
		        },
				error:function(data){
		            if(data.responseJSON.message){
		                toastr.error(data.responseJSON.message);
		            }
		            $.each(data.responseJSON.errors, function( index, value ) {
		                toastr.error(value);
						$('.form-control[name='+index+']').addClass('is-invalid');
						$('.form-control[name='+index+']').parent().append('<span id="password-error" class="error invalid-feedback">'+value+'</span>');
		            });
		        },
		        complete: function (data) {
		            _this.children('i').removeClass('fa-spin');
		            _this.children('i').removeClass('fa-circle-o-notch');
		            _this.children('i').addClass('fa-paper-plane-o');
		            _this.prop('disabled', false);
		        }
		    });
		    e.preventDefault();
		});



		/*----------------------------------------------------
		  COMENT FORM
		----------------------------------------------------*/
		$("#submit-comment").on('click', function(e) {

			toastr.clear();
			$('.error.invalid-feedback').remove();

			var _this = $(this);
			_this.children('i').addClass('fa-spin');
			_this.children('i').addClass('fa-circle-o-notch');
			_this.children('i').removeClass('fa-paper-plane-o');
			_this.prop('disabled', true);

			var dataString = {
				name       : $('#name').val(),
				email      : $('#email').val(),
				comment    : $('#comment').val(),
				post_id    : $('#comment-form').data('id'),
			};

			$.ajax({
				type: "POST",
				url: $('#comment-form').attr('action'),
				data: dataString,
				dataType    : 'json',
				encode      : true,
				success:function(data) {
					if(data.success){
						toastr.success(data.message);
					}else{
						if(data.message){
							toastr.error(data.message);
						}
						$.each(data.errors, function( index, value ) {
							toastr.error(value);
						});
					}
				},
				error:function(data){
					if(data.responseJSON.message){
						toastr.error(data.responseJSON.message);
					}
					$.each(data.responseJSON.errors, function( index, value ) {
						toastr.error(value);
						$('.form-control[name='+index+']').addClass('is-invalid');
						$('.form-control[name='+index+']').parent().append('<span id="password-error" class="error invalid-feedback">'+value+'</span>');
					});
				},
				complete: function (data) {
					_this.children('i').removeClass('fa-spin');
					_this.children('i').removeClass('fa-circle-o-notch');
					_this.children('i').addClass('fa-paper-plane-o');
					_this.prop('disabled', false);
				}
			});
			e.preventDefault();
		});



		/*----------------------------------------------------
		  COMENT FORM
		----------------------------------------------------*/
		$("#submit-newsletter").on('click', function(e) {

			toastr.clear();
			$('.error.invalid-feedback').remove();

			var _this = $(this);
			_this.children('i').addClass('fa-spin');
			_this.children('i').addClass('fa-circle-o-notch');
			_this.children('i').removeClass('fa-paper-plane-o');
			_this.prop('disabled', true);

			var dataString = {
				newsletter_name  : $('#newsletter_name').val(),
				newsletter_email : $('#newsletter_email').val()
			};

			$.ajax({
				type: "POST",
				url: $('#newsletter-form').attr('action'),
				data: dataString,
				dataType    : 'json',
				encode      : true,
				success:function(data) {
					if(data.success){
						toastr.success(data.message);
					}else{
						if(data.message){
							toastr.error(data.message);
						}
						$.each(data.errors, function( index, value ) {
							toastr.error(value);
						});
					}
				},
				error:function(data){
					if(data.responseJSON.message){
						toastr.error(data.responseJSON.message);
					}
					$.each(data.responseJSON.errors, function( index, value ) {
						toastr.error(value);
						$('.form-control[name='+index+']').addClass('is-invalid');
						$('.form-control[name='+index+']').parent().append('<span id="password-error" class="error invalid-feedback">'+value+'</span>');
					});
				},
				complete: function (data) {
					_this.children('i').removeClass('fa-spin');
					_this.children('i').removeClass('fa-circle-o-notch');
					_this.children('i').addClass('fa-paper-plane-o');
					_this.prop('disabled', false);
				}
			});
			e.preventDefault();
		});




        /*----------------------------------------------------
          GOOGLE MAP
        ----------------------------------------------------*/
        window.initialize = function () {
            var map;
            var bounds = new google.maps.LatLngBounds();

            // Google map Styles
            var mapOptions = {
                mapTypeId: 'roadmap',
                scrollwheel: false,
                draggable: true,
                styles: [{
                    "featureType": "administrative",
                    "elementType": "labels.text.fill",
                    "stylers": [{
                        "color": "#444444"
                    }]
                }, {
                    "featureType": "landscape",
                    "elementType": "all",
                    "stylers": [{
                        "color": "#f2f2f2"
                    }]
                }, {
                    "featureType": "poi",
                    "elementType": "all",
                    "stylers": [{
                        "visibility": "off"
                    }]
                }, {
                    "featureType": "road",
                    "elementType": "all",
                    "stylers": [{
                        "saturation": -100
                    }, {
                        "lightness": 45
                    }]
                }, {
                    "featureType": "road.highway",
                    "elementType": "all",
                    "stylers": [{
                        "visibility": "simplified"
                    }]
                }, {
                    "featureType": "road.arterial",
                    "elementType": "labels.icon",
                    "stylers": [{
                        "visibility": "off"
                    }]
                }, {
                    "featureType": "transit",
                    "elementType": "all",
                    "stylers": [{
                        "visibility": "off"
                    }]
                }, {
                    "featureType": "water",
                    "elementType": "all",
                    "stylers": [{
                        "color": "#46bcec"
                    }, {
                        "visibility": "on"
                    }]
                }]
            };


            // Display a map on the page
            map = new google.maps.Map(document.getElementById("map"), mapOptions);
            map.setTilt(45);

            // Enter your Company's Latitude & Longtitude to be shown on the map
            var markers = [
                ['Cariera', 40.710439, -74.005072],
            ];

            // Info Window Content
            var infoWindowContent = [
                ['<div class="info_content">' +
                '<h5>Cariera</h5>' +
                '<p>Your address here</p>' + '</div>']
            ];

            // Pin Icon
            var pin = 'images/icons/pin.png';

            // Display multiple markers on a map
            var infoWindow = new google.maps.InfoWindow(),
                marker, i;

            // Loop through our array of markers & place each one on the map
            for (i = 0; i < markers.length; i++) {
                var position = new google.maps.LatLng(markers[i][1], markers[i][2]);
                bounds.extend(position);
                marker = new google.maps.Marker({
                    position: position,
                    map: map,
                    title: markers[i][0],
                    icon: pin
                });

                // Allow each marker to have an info window
                google.maps.event.addListener(marker, 'click', (function (marker, i) {
                    return function () {
                        infoWindow.setContent(infoWindowContent[i][0]);
                        infoWindow.open(map, marker);
                    }
                })(marker, i));

                // Automatically center the map fitting all markers on the screen
                map.fitBounds(bounds);
            }

            // Override our map zoom level once our fitBounds function runs (Make sure it only runs once)
            var boundsListener = google.maps.event.addListener((map), 'bounds_changed', function (event) {
                this.setZoom(15);
                google.maps.event.removeListener(boundsListener);
            });

        }





        /*----------------------------------------------------
          FAQ
        ----------------------------------------------------*/
        var topic = $('.topic .open'),
            question = $('.question'),
            liveSearch = $('.live-search-box');

        $(topic).on('click', function () {
            var container = $(this).parents(".topic");
            var answer = container.find(".answer");

            answer.slideToggle(200);

            if (container.hasClass("expanded")) {
                container.removeClass("expanded");
            } else {
                container.addClass("expanded");
            }
        });

        $(question).each(function () {
            $(this).attr('data-search-term', $(this).text().toLowerCase());

        });

        $(liveSearch).on('keyup', function () {
            var searchTerm = $(this).val().toLowerCase();

            $(question).each(function () {
                if ($(this).filter('[data-search-term *= ' + searchTerm + ']').length > 0 || searchTerm.length < 1) {
                    $(this).parent().parent().show();
                } else {
                    $(this).parent().parent().hide();
                }
            });
        });









        /*----------------------------
         PRICE SLIDER
        ------------------------------ */
    




        /*----------------------------------------------------
          SKILLBAR
        ----------------------------------------------------*/
        var skills = $('.skills'),
            skill_bar = $('.skillbar'),
            animated_bar = $('.skillbar-bar');

        $(skills).on('inview', function (event, visible, visiblePartX, visiblePartY) {
            if (visible) {
                jQuery(skill_bar).each(function () {
                    jQuery(this).find(animated_bar).animate({
                        width: jQuery(this).attr('data-percent')
                    }, 2500);
                });
                $(this).unbind('inview');
            }
        });



    }); //end of document ready function

})(jQuery);

const observer = lozad();
observer.observe();
