<div>
<div class="sidebar__inner">
	<div class="row">
		<!-- Start of Popular Posts -->
		<div class="col-md-12 widget clearfix">
		    <h4 class="widget-title">{{__('latest posts')}}</h4>
		    @foreach($latestPosts ?? [] as $post)
		    <div class="sidebar-blog-post">
		        <div class="thumbnail-post">
		            <a href="{{$post->url}}" title="{{$post->title}}">
		                <img src="{{$post->thumbnail(100)['src']}}" alt="{{$post->title}}" />
		            </a>
		        </div>
		        <div class="post-info">
		            <a href="{{$post->url}}">{{$post->title}}</a>
		            <p>{{$post->description}}</p>
		        </div>
		    </div>
			@endforeach
		</div>
		<!-- End of Popular Posts -->


		<!-- Start of Newsletter -->
		<div class="col-md-12 widget">
		    <h4 class="widget-title">{{__('newsletter')}}</h4>
		    <form method="post" id="newsletter-form" class="text-right" action="{{route('frontend.newsletter.submit')}}">
		        <div class="form-group">
					<input type="text" id="newsletter_name" name="newsletter_name" class="form-control" placeholder="{{__('Your Name')}}" autocomplete="off">
				</div>
		        <div class="form-group">
		            <input type="email" id="newsletter_email" name="newsletter_email" class="form-control mt10"  placeholder="{{__('Your Email')}}" autocomplete="off">
				</div>
		        <button type="submit" id="submit-newsletter" class="btn btn-default btn-effect">{{__('Subscribe')}} <i class="far fa-paper-plane"></i></button>
		    </form>
		</div>
		<!-- End of Newsletter -->


		<!-- Start of Trending Tags -->
		<div class="col-md-12 widget">
		    <h4 class="widget-title">{{__('trending tags')}}</h4>

		    <!-- Tags Wrapper -->
		    <div class="tag-wrapper">
				@foreach($trendingTags ?? [] as $tag)
				<a href="{{route('frontend.blog.tag',['tag_slug'=>$tag->slug])}}" class="tag-link">{{$tag->title}}</a>
				@endforeach
		    </div>
		</div>
		<!-- End of Trending Tags -->

		<!-- Start of Categories -->
		<div class="col-md-12 widget">
		    <h4 class="widget-title">{{__('Popular Categories')}}</h4>
		    <ul class="sidebar-list">
				@foreach($popularCategories ?? [] as $category)
					<li><a href="{{route('frontend.page',['page_slug'=>$category->slug])}}">{{$category->title}}</a></li>
				@endforeach
		    </ul>
		</div>
		<!-- End of Categories -->
	</div>
</div>
</div>
