<!-- =============== Start of Header 1 Navigation =============== -->
<header>
	<div class="container">
		<div class="row">
			<div class="col-md-4 header-logo">
				<a class="navbar-brand" href="{{route('frontend.index')}}" title="{{__('home')}}">
					<img src="{{url('/storage/'.config('app.logo.src'))}}" alt="{{ config('app.name')[Config::get('app.locale')] }}" class="brand-image" />
				</a>
			</div>
			<div class="col-md-5 header-contact">
				<div class="row">
					<div class="col-md-6">
						<div class="icon">
							<span class="far fa-paper-plane"></span>
						</div>
						<div class="text">
							<b>{{__('Email')}}</b>
							<p><a {{__('Email')}} href="mailto:{{ Config::get('app.contact.credential.email') }}">{{ Config::get('app.contact.credential.email') }}</a></p>
						</div>
					</div>
					<div class="col-md-6">
						<div class="icon">
							<span class="fab fa-whatsapp"></span>
						</div>
						<div class="text">
							<b>{{__('Whatsapp')}}</b>
							<p><a title="{{__('Whatsapp')}}" href="https://wa.me/{{ Config::get('app.contact.whatsapp') }}">{{ Config::get('app.contact.whatsapp') }}</a></p>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-3 header-buttons">
				<div class="dropdown">
					<button class="btn btn-sm login-btn btn-header dropdown-toggle" id="navToggleLanguages" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							{{json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['name']}}
					</button>
					<div class="dropdown-menu" aria-labelledby=="navToggleLanguages" >
						@foreach(Config::get('app.languages') as $language)
							<a class="dropdown-item" title="{{$language->name}}" href="{{url($language->prefix."/".Config::get('app.default.clean-uri'))}}">{{$language->name}}</a>
						@endforeach
					</div>
				</div>
				@if(Auth::check())
					<div class="dropdown">
						<button class="btn btn-sm login-btn btn-header dropdown-toggle" type="button" id="navToggleCommercial" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							<i class="fas fa-user"></i>
						</button>
						<div class="dropdown-menu" aria-labelledby=="navToggleCommercial" >
							@can('dashboard-access')
								<a title="{{__('dashboard')}}" href="{{route('dashboard.index')}}" class="dropdown-item">
									<i class="fas fa-tachometer-alt"></i>
									{{__('Dashboard')}}
								</a>
							@endcan
							<a title="{{__('Customer Area')}}" href="{{route('customer.index')}}" class="dropdown-item">
								<i class="fas fa-house-user"></i>
								{{__('Customer Area')}}
							</a>
							<a title="{{__('Logout')}}" href="{{route('logout')}}" class="dropdown-item" onclick="event.preventDefault();document.getElementById('logout-form').submit();">
								<i class="fas fa-sign-out-alt"></i>
								{{__('Logout')}}
							</a>
						</div>
					</div>
				@else
					<a href="{{route('login')}}" class="btn btn-sm login-btn btn-header" title="{{__('login')}}">
						<i class="fas fa-sign-in-alt"></i>
						{{__('login')}}
					</a>
				@endif
			</div>
		</div>
	</div>


	<nav class="navbar navbar-expand-md navbar-dark">

		<div class="container">
			<div class="container position-relative p-0">

				<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#main-nav" aria-controls="main-nav" aria-expanded="false" aria-label="Toggle navigation">
				    <span class="fas fa-bars"></span>
				</button>

				<form action="/search/" class="form-inline searchform">
					<div class="form-group">
						<input type="text" class="form-control pl-3" placeholder="{{__('Search')}} ..." value="{{request('term')}}" />
						<button type="submit" class="form-control search"><span class="fas fa-search"></span></button>
					</div>
				</form>

				<div class="collapse navbar-collapse" id="main-nav">

					<ul class="nav navbar-nav">
						@foreach(Afrodien::mainNav() as $li)
						<li class="nav-item
							@if($li['slug']=='home' && trim(Request::path(),'/')=="") active @endif
							@if($li['slug']=='home' && trim(Request::path(),'/')==Config::get('app.locale')) active @endif
							@if($li['slug']==trim(Request::path(),'/')) active @endif
							@if(Config::get('app.locale')."/".$li['slug']==trim(Request::path(),'/')) active @endif
							@if(Route::current() && Route::current()->getName()=="frontend.".$li['slug']) active @endif
						">
							<a class="nav-link" itemprop="url" href="{{route('frontend.page',['page_slug'=>$li['slug']])}}" role="button" title="{{$li['title'][Config::get('app.locale')]}}">{{$li['title'][Config::get('app.locale')]}}</a>
						</li>
						@endforeach
					</ul>

				</div>
			</div>

		</div>
	</nav>

</header>
<!-- =============== End of Header 1 Navigation =============== -->
