@extends('themes.alnakhlawy.app')

@section('content')

<!-- =============== Start of Page Header 1 Section =============== -->
<section class="page-header" style="background-image: url('{{$page->featuredImage['src']}}');">
    <div class="container">

        <!-- Start of Page Title -->
        <div class="row">
            <div class="col-md-12">
                <h2>{{$page->title}}</h2>
            </div>
        </div>
        <!-- End of Page Title -->

        <!-- Start of Breadcrumb -->
		<div class="row">
			<div class="col-md-12">
				<nav aria-label="breadcrumb">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
						<li class="breadcrumb-item"><a href="{{route('frontend.store')}}">{{__('Store')}}</a></li>
						<li class="breadcrumb-item"><a href="{{$page->category->url}}">{{$page->category->title}}</a></li>
						<li class="breadcrumb-item active" aria-current="page">{{$page->title}}</li>
					</ol>
				</nav>
			</div>
        </div>
        <!-- End of Breadcrumb -->

    </div>
</section>
<!-- =============== End of Page Header 1 Section =============== -->





<!-- ===== Start of Shop Cart Section ===== -->
<section class="shop">
    <div class="container">

        <!-- Start of Row -->
        <div class="row">

            <!-- ===== Start of Product Wrapper ===== -->
            <div class="col-md-8 col-xs-12 product-wrapper">

                <!-- ===== Start of Row ===== -->
                <div class="row">
                    <!-- Start of First Column -->
                    <div class="col-md-6">

                        <!-- ===== Start of Owl Slider ===== -->
                        <div class="owl-carousel product-slider">
							@foreach ($page->media ?? [] as $image)
	                            <div class="item">
	                                <div>
	                                    <img src="{{$page->featuredImage['src']}}" alt="" class="img-responsive">
	                                </div>
	                            </div>
							@endforeach


                        </div>
                        <!-- ===== End of Owl Slider ===== -->

                    </div>
                    <!-- End of First Column -->


                    <!-- Start of Second Column -->
                    <div class="col-md-6">

                        <!-- Start of Product Details -->
                        <div class="product-details">

                            <h2>{{$page->title}}</h2>

                            <!-- Start of Product Rating -->
                            <div class="product-rating mt10">
                                <i class="fa fa-star" aria-hidden="true"></i>
                                <i class="fa fa-star" aria-hidden="true"></i>
                                <i class="fa fa-star" aria-hidden="true"></i>
                                <i class="fa fa-star" aria-hidden="true"></i>
                                <i class="fa fa-star-half-o" aria-hidden="true"></i>
                            </div>
                            <!-- End of Product Rating -->

                            <!-- Start of Product Price -->
                            <div class="product-price">
								@empty($page->special_price)
									<span class="price">${{$page->price}}</span>
								@else
									<del><span class="price">${{$page->price}}</span></del>
									<span class="price">${{$page->special_price}}</span>
								@endempty
                            </div>
                            <!-- End of Product Price -->

                            <p>{{$page->description}}</p>


                            <!-- Start of Product Quantity -->
                            <div class="product-cart">
                                <div class="input-group product-quantity">
                                    <input type="button" value="-" class="minus">
                                    <input type="text" class="qty" value="1">
                                    <input type="button" value="+" class="plus">
                                </div>
                            </div>
                            <!-- End of Product Quantity -->

                            <button class="btn btn-default btn-effect">Add to Cart</button>

                        </div>
                        <!-- End of Product Details -->

                    </div>
                    <!-- End of Second Column -->
                </div>
                <!-- ===== End of Row ===== -->


                <!-- ===== Start of Row ===== -->
                <div class="row mt60">
                    <div class="col-md-12">

                        <!-- Start of Tabs Product -->
                        <div class="tabs tabs-product">

                            <!-- Start of Nav Tabs -->
                            <ul class="nav nav-tabs">
                                <li>
                                    <a class="active" href="#productDescription" data-toggle="tab" aria-expanded="false">Description</a>
                                </li>

                                <li>
                                    <a href="#productReviews" data-toggle="tab" aria-expanded="true">Reviews ({{count($page['reviews'])}})</a>
                                </li>
                            </ul>
                            <!-- End of Nav Tabs -->


                            <!-- Start of Tab Content -->
                            <div class="tab-content">

                                <!-- Start of Tab Pane -->
                                <div class="tab-pane active" id="productDescription">
									{{$page->details}}
								</div>
                                <!-- End of Tab Pane -->


                                <!-- Start of Tab Pane -->
                                <div class="tab-pane" id="productReviews">

                                    <!-- Start of Comments -->
                                    <ul class="comments-list">

                                        @foreach ($page['reviews'] ?? [] as $review)

	                                        <!-- Start of Comment 2 -->
	                                        <li class="comment">
	                                            <!-- Commenter Image -->
	                                            <a class="pull-left commenter" href="#">
	                                                <img src="{{$review->user->avatar()}}" alt="" class="img-responsive">
	                                            </a>

	                                            <div class="media-body comment-body">
	                                                <!-- Comment Wrapper -->
	                                                <div class="comment-content-wrapper">
	                                                    <div class="media-heading clearfix">

	                                                        <!-- Commenters Name -->
	                                                        <h6 class="commenter-name">{{$review->user->name}}</h6>

	                                                        <div class="comment-rating pull-right">
	                                                            <i class="fa fa-star" aria-hidden="true"></i>
	                                                            <i class="fa fa-star" aria-hidden="true"></i>
	                                                            <i class="fa fa-star" aria-hidden="true"></i>
	                                                            <i class="fa fa-star" aria-hidden="true"></i>
	                                                            <i class="fa fa-star-half-o" aria-hidden="true"></i>
	                                                        </div>

	                                                        <!-- Comment Info -->
	                                                        <div class="comment-info">
	                                                            <span>{{$review->created_at}}</span>
	                                                        </div>

	                                                        <!-- Comment -->
	                                                        <p>{!! base64_decode($review->content) !!}</p>
	                                                    </div>
	                                                </div>
	                                                <!-- End of Comment Wrapper -->
	                                            </div>
	                                        </li>
	                                        <!-- End of Comment 2 -->
										@endforeach

                                    </ul>
                                    <!-- End of Comments -->

                                </div>
                                <!-- End of Tab Pane -->

                            </div>
                            <!-- End of Tab Content -->

                        </div>
                        <!-- End of Tabs Product -->

                    </div>
                </div>
                <!-- ===== End of Row ===== -->


                <!-- ===== Start of Row ===== -->
                <div class="row mt60">
                    <div class="col-md-12">
						<h4 class="widget-title">related products</h4>
                    </div>


					@foreach ($related ?? [] as $product)
	                    <!-- Start of Product 1 -->
	                    <div class="col-md-4 col-sm-6 col-xs-12 mt40">
	                        <div class="product nomargin">

	                            <!-- Product Image -->
	                            <div class="product-image">

	                                <a href="{{$product->featuredImage['src']}}" class="hover-zoom">
	                                    <img src="{{$product->featuredImage['src']}}" class="img-responsive" alt="">
	                                </a>

	                                <!-- Product overlay -->
	                                <div class="product-overlay">
	                                    <a href="{{$product->url}}"><i class="fa fa-shopping-cart"></i>Add to Cart</a>
	                                </div>

	                            </div>

	                            <!-- Product Description -->
	                            <div class="product-descr">

	                                <a href="{{$product->url}}">
	                                    <h5>{{$product->title}}</h5>

	                                    <!-- Price -->
	                                    <span class="price">
	                                        <span class="amount">${{$product->price}}</span>
	                                    </span>
	                                </a>
	                            </div>

	                        </div>
	                    </div>
	                    <!-- End of Product 1 -->
					@endforeach


                </div>
                <!-- ===== Start of Row ===== -->

            </div>
            <!-- ===== End of Product Wrapper ===== -->


			<div class="col-md-4 col-xs-12 blog-sidebar">
				@include('themes.alnakhlawy.inc.store-aside')
			</div>


        </div>
        <!-- End of Row -->
    </div>

</section>
<!-- ===== End of Shop Cart Section ===== -->





@endsection
