@extends('themes.alnakhlawy.app')

@section('content')
	<!-- =============== Start of Page Header 1 Section =============== -->
	<section class="page-header" style="background-image: url('{{asset('/storage/users/user-1.jpg')}}');">
	    <div class="container">

	        <!-- Start of Page Title -->
	        <div class="row">
	            <div class="col-md-12">
	                <h2>{{$page->title}}</h2>
	            </div>
	        </div>
	        <!-- End of Page Title -->

	        <!-- Start of Breadcrumb -->
			<div class="row">
				<div class="col-md-12">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
							<li class="breadcrumb-item active" aria-current="page">{{$page->title}}</li>
						</ol>
					</nav>
				</div>
	        </div>
	        <!-- End of Breadcrumb -->

	    </div>
	</section>
	<!-- =============== End of Page Header 1 Section =============== -->





<!-- ===== Start of Login - Register Section ===== -->
<section id="register">
    <div class="container">
		<div class="row">

			<div class="col-md-8 col-md-offset-2 offset-md-2">

				<div class="register-box">

					@if(Config::get('app.registration.status')=='closed')
						<form action="{{ route('register') }}" method="post" id="register-form">
							Sorry, registration is closed.
						</form>
					@else
						<form action="{{ route('register') }}" method="post" id="register-form">

							@csrf

							@error('demo')
								<span class="invalid-feedback" role="alert">
									<strong>{{ $message }}</strong>
								</span>
							@enderror

							@error('status')
								<span class="invalid-feedback" role="alert">
									<strong>{{ $message }}</strong>
								</span>
							@enderror

							<!-- Form Group -->
							<div class="form-group">
								<label>{{__('Full Name')}}</label>
								<input type="text" class="form-control" name="name" placeholder="{{__('Full Name')}}"value="{{ old('name') }}" autocomplete="name" autofocus />
								@error('name')
									<span class="invalid-feedback" role="alert">
										<strong>{{ $message }}</strong>
									</span>
								@enderror
							</div>

							<!-- Form Group -->
							<div class="form-group">
								<label>{{__('Username')}}</label>
								<input type="text" class="form-control" name="username" placeholder="{{__('Username')}}" value="{{ old('username') }}" required autocomplete="username" />
								@error('username')
									<span class="invalid-feedback" role="alert">
										<strong>{{ $message }}</strong>
									</span>
								@enderror
							</div>

							<!-- Form Group -->
							<div class="form-group">
								<label>{{__('Email')}}</label>
								<input type="email" class="form-control" name="email" placeholder="{{__('Email')}}" value="{{ old('email') }}" autocomplete="email" />
								@error('email')
									<span class="invalid-feedback" role="alert">
										<strong>{{ $message }}</strong>
									</span>
								@enderror
							</div>

							<!-- Form Group -->
							<div class="form-group">
								<label>{{__('Password')}}</label>
								<input type="password" class="form-control" name="password" placeholder="{{__('Password')}}" />
								@error('password')
									<span class="invalid-feedback" role="alert">
										<strong>{{ $message }}</strong>
									</span>
								@enderror
							</div>

							<!-- Form Group -->
							<div class="form-group mb30">
								<label>{{__('Confirm Password')}}</label>
								<input type="password" class="form-control" name="password_confirmation" placeholder="{{__('Confirm Password')}}" />
							</div>

							<div class="form-group">
		                        <div class="row">
		                            <div class="col-7 text-as-lang">
		                                <input type="checkbox" name="agree" id="agree" />
		                                <label for="agree">{{__('Agree with the')}} <a href="{{route('frontend.page',['page_slug'=>'terms-and-conditions'])}}">{{__('Terms and Conditions')}}</a></label>
										@error('agree')
											<div class="invalid-feedback" role="alert">
												<strong>{{ $message }}</strong>
											</div>
										@enderror
									</div>
									<div class="col-5 text-not-as-lang">
				                        <button class="btn btn-default btn-effect" id="submit-register-form" name="login">{{__('create account')}} <i class="fa fa-paper-plane-o"></i></button>
				                    </div>
		                        </div>
		                    </div>

						</form>
					@endif
				</div>
			</div>
		</div>

    </div>
</section>
<!-- ===== End of Login - Register Section ===== -->

@endsection
