@extends('themes.alnakhlawy.app')

@section('content')

	<!-- =============== Start of Page Header 1 Section =============== -->
	<section class="page-header" style="background-image: url('{{asset('/storage/users/user-1.jpg')}}');">
	    <div class="container">

	        <!-- Start of Page Title -->
	        <div class="row">
	            <div class="col-md-12">
					<h2>{{$title}}</h2>
	            </div>
	        </div>
	        <!-- End of Page Title -->

	        <!-- Start of Breadcrumb -->
	        <div class="row">
	            <div class="col-md-12">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
							<li class="breadcrumb-item"><a href="{{route('frontend.search',['term'=>' '])}}">{{$title}}</a></li>
							<li class="breadcrumb-item active" aria-current="page">{{request('term')}}</li>
						</ol>
					</nav>
	            </div>
	        </div>
	        <!-- End of Breadcrumb -->

	    </div>
	</section>
	<!-- =============== End of Page Header 1 Section =============== -->





	<!-- ===== Start of Blog Listing Section ===== -->
	<section class="blog-listing ptb80" id="version1">
	    <div class="container">
	        <div class="row">

	            <div class="col-md-8 col-xs-12 blog-posts-wrapper">

					@foreach($posts ?? [] as $post)
						@php
							$post->structure();
						@endphp
	                    <article class="blog-post">

	                        <!-- Blog post Thumbnail -->
	                        <div class="blog-thumbnail">
	                            <a href="{{$post->url}}" class="hover-link">
									<picture>
										<source media="(max-width: 330px)" srcset="{{$post->thumbnail(300)['src']}}">
										<source media="(max-width: 767px)" srcset="{{$post->thumbnail(600)['src']}}">
										<source media="(max-width: 991px)" srcset="{{$post->thumbnail(450)['src']}}">
										<img src="{{$post->thumbnail(450)['src']}}" title="{{$post->title}}" class="img-responsive" />
									</picture>
	                            </a>
	                        </div>

	                        <!-- Blog post Description -->
	                        <div class="blog-desc">
	                            <h5><a href="{{$post->url}}">{{ $post->title !==null ? $post->title : '' }}</a></h5>
	                            <div class="post-detail">
	                                <span><i class="fa fa-user"></i>{{$post->user->name}}</span>
	                                <span><i class="fa fa-clock-o"></i>{{$post->updated_at->diffForHumans()}}</span>
	                            </div>
	                            <p>{{$post->description}} ... <a href="{{$post->url}}" >{{__('read more')}}</a></p>

	                        </div>
	                    </article>
	                @endforeach

                    @isset($posts)
	                <!-- Start of Pagination -->
	                <div class="col-md-12 text-center">
						{{ $posts->links() }}
	                </div>
	                <!-- End of Pagination -->
                    @endisset
	            </div>

	            <!-- Start of Blog Posts -->
	            <div class="col-md-4 col-xs-12 blog-sidebar">
					@include('themes.alnakhlawy.inc.aside')
	            </div>
	            <!-- End of Blog Posts -->



	        </div>
	    </div>
	</section>
@endsection


@section('scripts')
	<script src="{{asset('plugins/sticky/jquery.sticky-kit.js')}}"></script>
@endsection
