@extends('themes.alnakhlawy.app')

@section('content')
	<!-- =============== Start of Page Header 1 Section =============== -->
	<section class="page-header" style="background-image: url('{{$service->featuredImage['src']}}');">
	    <div class="container">

	        <!-- Start of Page Title -->
	        <div class="row">
	            <div class="col-md-12">
	                <h2>{{$title}}</h2>
	            </div>
	        </div>
	        <!-- End of Page Title -->

	        <!-- Start of Breadcrumb -->
	        <div class="row">
	            <div class="col-md-12">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="{{route('frontend.index')}}">{{__('Home')}}</a></li>
							<li class="breadcrumb-item"><a href="{{route('frontend.services.index')}}">{{__('services')}}</a></li>
							<li class="breadcrumb-item active" aria-current="page">{{$service->title}}</li>
						</ol>
					</nav>
	            </div>
	        </div>
	        <!-- End of Breadcrumb -->

	    </div>
	</section>
	<!-- =============== End of Page Header 1 Section =============== -->





	<!-- ===== Start of Single Blog Post Section ===== -->
	<section id="blog-post">

	    <meta itemprop="datePublished" content="{{$service['created_at']}}" />
	    <meta itemprop="dateModified" content="{{$service['updated_at']}}" />
	    <meta itemprop="headline" content="{{$service['title']}}" />
	    <meta itemprop="description" content="{{$service['description']}}" />
	    <meta itemprop="image" content="{{$service->featuredImage['src']}}" />

	    <div class="container">
		    <div class="row">

		        <!-- Start of Blog Post Content Wrapper -->
		        <div class="col-md-8 col-xs-12 post-content-wrapper">

		            <!-- Start of Post Title -->
		            <div class="post-title">
		                <h2>{{$service['title']}}</h2>
		                <!-- Post Details -->
		                <div class="post-detail">
		                    <span><i class="far fa-clock"></i>{{ (new Carbon\Carbon($service['updated_at']))->diffForHumans()}}</span>
		                </div>
		            </div>
		            <!-- End of Post Title -->

		            <!-- Start of Post Content -->
		            <div class="post-content">
						<hr>

		                {!! $service['content'] !!}


		                <hr>

						<div class="text-center">
							<!-- Start of Social Media Buttons -->
						    <ul class="social-btns list-inline">
			                    <!-- Social Media -->
			                    <li>
			                        <a href="https://www.facebook.com/sharer.php?t={{$service['title']}}&u={{$service->url}}" class="social-btn-roll facebook">
			                            <div class="social-btn-roll-icons">
			                                <i class="social-btn-roll-icon fab fa-facebook-f"></i>
			                                <i class="social-btn-roll-icon fab fa-facebook-f"></i>
			                            </div>
			                        </a>
			                    </li>

			                    <!-- Social Media -->
			                    <li>
			                        <a href="https://twitter.com/intent/tweet?text=&url={{$service->url}}" class="social-btn-roll twitter">
			                            <div class="social-btn-roll-icons">
			                                <i class="social-btn-roll-icon fab fa-twitter"></i>
			                                <i class="social-btn-roll-icon fab fa-twitter"></i>
			                            </div>
			                        </a>
			                    </li>

			                    <!-- Social Media -->
			                    <li>
			                        <a href="https://www.pinterest.com/pin/create/button/?description={{$service['description']}}&media={{$service->featuredImage['src']}}&url={{$service->url}}" class="social-btn-roll pinterest">
			                            <div class="social-btn-roll-icons">
			                                <i class="social-btn-roll-icon fab fa-pinterest-p"></i>
			                                <i class="social-btn-roll-icon fab fa-pinterest-p"></i>
			                            </div>
			                        </a>
			                    </li>

			                    <!-- Social Media -->
			                    <li>
			                        <a href="https://www.linkedin.com/shareArticle?title={{$service['title']}}&url={{$service->url}}" class="social-btn-roll linkedin">
			                            <div class="social-btn-roll-icons">
			                                <i class="social-btn-roll-icon fab fa-linkedin-in"></i>
			                                <i class="social-btn-roll-icon fab fa-linkedin-in"></i>
			                            </div>
			                        </a>
			                    </li>
			                </ul>
			                <!-- End of Social Media Buttons -->
						</div>

		            </div>
		            <!-- End of Post Content -->

		        </div>
		        <!-- End of Blog Post Content Wrapper -->

		        <div class="col-md-4 col-xs-12 blog-sidebar">
					@include('themes.alnakhlawy.inc.aside')
		        </div>

		    </div>
	    </div>
	</section>
	<!-- ===== End of Single Blog Post Section ===== -->
@endsection


@section('scripts')
	<script src="{{asset('plugins/sticky/jquery.sticky-kit.js')}}"></script>
@endsection
