<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVirtualSystemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('virtual_systems', function (Blueprint $table) {
            $table->id();
            $table->string('slug')->unique();
            $table->json('fields');
            $table->text('notes');
            $table->string('title_en');
            $table->string('title_ar');
            $table->string('operations');
            $table->string('key');
            $table->string('table_name')->unique();
            $table->enum('display',['1','0']);
            $table->timestamps();
			$table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(){
        $Systems = \App\VirtualSystem::all();
        foreach ($Systems as $System){
            Schema::dropIfExists($System->table);
        }
        Schema::dropIfExists('virtual_systems');
    }
}
